using System;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Xml;
using Microsoft.ContentManagement.Publishing;
using Microsoft.ContentManagement.Publishing.Extensions.Placeholders;
using Microsoft.ContentManagement.WebControls.Design;
using Microsoft.ContentManagement.WebControls;

namespace ContosoNetControls
{
	/// <summary>
	/// Summary description for CustomProperties.
	/// </summary>
	[ SupportedPlaceholderDefinitionType( typeof(XmlPlaceholderDefinition) ) ]
	public class JobDetails : BasePlaceholderControl
	{
		public JobDetails()
		{
			//
			// TODO: Add constructor logic here
			//
		}

		#region Presentation Logic

		private Table presentationTable;

		protected override void CreatePresentationChildControls
			(BaseModeContainer presentationContainer)
		{
			Posting thisPosting = CmsHttpContext.Current.Posting;
			presentationTable = new Table();
			presentationTable.BorderWidth = 1;
			presentationTable.BorderColor = System.Drawing.Color.Black;

			presentationContainer.Controls.Add (presentationTable);
		}

		private void AddPropertyForPresentation (Table table, string propName, string propValue)
		{
			TableCell nameCell = new TableCell();
			nameCell.Text = propName;
			nameCell.Font.Bold = true;
			nameCell.VerticalAlign = VerticalAlign.Top;
			nameCell.HorizontalAlign = HorizontalAlign.Left;

			TableCell valueCell = new TableCell();
			valueCell.Text = propValue;
			valueCell.VerticalAlign = VerticalAlign.Top;
			valueCell.HorizontalAlign = HorizontalAlign.Left;

			TableRow row = new TableRow();
			row.Cells.Add (nameCell);
			row.Cells.Add (valueCell);
			table.Rows.Add (row);
		}

		protected override void LoadPlaceholderContentForPresentation(PlaceholderControlEventArgs e)
		{
			InitXml ((this.BoundPlaceholder as XmlPlaceholder).XmlAsString);
			Posting thisPosting = CmsHttpContext.Current.Posting;

			XmlElement rootElement = xmlStore.ChildNodes[0] as XmlElement;
			if (rootElement != null)
			{
				foreach (XmlNode node in rootElement.ChildNodes)
				{
					XmlElement element = node as XmlElement;
					if (element != null)
					{
						string propName = element.Name;
						string propVal = element.InnerText;
						AddPropertyForPresentation (presentationTable, propName, propVal);
					}
				}
			}
		}


		#endregion

		#region Authoring Logic

//		private Table authoringTable;
		protected override void CreateAuthoringChildControls(BaseModeContainer authoringContainer)
		{
			Literal literal = new Literal();
			literal.Text = "Job details cannot be changed from this posting.";
			authoringContainer.Controls.Add (literal);
//			Posting thisPosting = CmsHttpContext.Current.Posting;
//			authoringTable = new Table();
//			authoringTable.BorderWidth = 1;
//			authoringTable.BorderColor = System.Drawing.Color.Black;
//
//			foreach (CustomProperty p in thisPosting.CustomProperties)
//			{
//				AddPropertyForAuthoring (authoringTable, p);
//			}
//
//			authoringContainer.Controls.Add (authoringTable);
		}

		private void AddPropertyForAuthoring (Table table, CustomProperty prop)
		{
//			string propName = prop.Name;
//
//			TableCell nameCell = new TableCell();
//			nameCell.Text = propName;
//			nameCell.Font.Bold = true;
//			nameCell.VerticalAlign = VerticalAlign.Top;
//			nameCell.HorizontalAlign = HorizontalAlign.Left;
//
//			TableCell valueCell = new TableCell();
//			if (prop.AllowedValues.Count > 0)
//			{
//				DropDownList list = new DropDownList();
//				list.ID = "propDDList" + propName;
//				list.Width = Unit.Pixel (100);
//				
//				foreach (string allowedVal in prop.AllowedValues)
//				{
//					ListItem item = new ListItem(allowedVal, allowedVal);
//					list.Items.Add (item);
//				}
//
//				valueCell.Controls.Add (list);
//			}
//			else
//			{
//				TextBox textbox = new TextBox();
//				textbox.ID = "propTextBox" + propName;
//				textbox.Width = Unit.Pixel (100);
//				valueCell.Controls.Add (textbox);
//			}
//			valueCell.VerticalAlign = VerticalAlign.Top;
//			valueCell.HorizontalAlign = HorizontalAlign.Left;
//
//			TableRow row = new TableRow();
//			row.Cells.Add (nameCell);
//			row.Cells.Add (valueCell);
//			table.Rows.Add (row);
		}

		protected override void LoadPlaceholderContentForAuthoring(PlaceholderControlEventArgs e)
		{
//			InitXml ((this.BoundPlaceholder as XmlPlaceholder).XmlAsString);
//
//			Posting thisPosting = CmsHttpContext.Current.Posting;
//			int rowIndex = 0;
//
//			foreach (CustomProperty prop in thisPosting.CustomProperties)
//			{
//				string propVal = GetFromXml (prop.Name);
//				TableCell cell = authoringTable.Rows[rowIndex].Cells[1];
//
//				if (prop.AllowedValues.Count > 0)
//				{
//					// There are specific allowed values - so fill in the drop down list
//					DropDownList list = cell.Controls[0] as DropDownList;
//					if (list == null)
//					{
//						throw new Exception ("Invalid control for custom property");
//					}
//					bool foundItem = false;
//					int itemIndex = 0;
//					foreach (ListItem item in list.Items)
//					{
//						if (item.Value == propVal)
//						{
//							foundItem = true;
//							list.SelectedIndex = itemIndex;
//						}
//						itemIndex++;
//					}
//					if (!foundItem)
//					{
//						throw new Exception ("Value of " + prop.Name + " not in allowed list");
//					}
//				}
//				else
//				{
//					// There are no specific allowed values - we expect a text box
//					TextBox tb = cell.Controls[0] as TextBox;
//					if (tb == null)
//					{
//						throw new Exception ("Invalid control for custom property");
//					}
//					tb.Text = propVal;
//				}
//				rowIndex++;
//			}
		}

		protected override void SavePlaceholderContent(PlaceholderControlSaveEventArgs e)
		{
//			Posting thisPosting = CmsHttpContext.Current.Posting;
//			int rowIndex = 0;
//			InitXml ("");
//
//			foreach (CustomProperty prop in thisPosting.CustomProperties)
//			{
//				string propVal;
//				TableCell cell = authoringTable.Rows[rowIndex].Cells[1];
//
//				if (prop.AllowedValues.Count > 0)
//				{
//					// There are specific allowed values - so data is in a drop down list
//					DropDownList list = cell.Controls[0] as DropDownList;
//					if (list == null)
//					{
//						throw new Exception ("Invalid control for custom property");
//					}
//					propVal = list.SelectedValue;
//				}
//				else
//				{
//					// There are no specific allowed values - we expect a text box
//					TextBox tb = cell.Controls[0] as TextBox;
//					if (tb == null)
//					{
//						throw new Exception ("Invalid control for custom property");
//					}
//					propVal = tb.Text;
//				}
//
//				AddToXml (prop.Name, propVal);
//				rowIndex++;
//			}
//			
//			XmlPlaceholder placeholder = this.BoundPlaceholder as XmlPlaceholder;
//			if (placeholder == null)
//			{
//				throw new Exception ("Invalid placeholder bound to CustomProperties control");
//			}
//			placeholder.XmlAsString = GetXmlString();
		}

		protected override void OnPopulatingDefaultContent(PlaceholderControlCancelEventArgs e)
		{
//			base.OnPopulatingDefaultContent (e);
//			Posting thisPosting = CmsHttpContext.Current.Posting;
//			int rowIndex = 0;
//
//			foreach (CustomProperty prop in thisPosting.CustomProperties)
//			{
//				string propDefault = prop.DefaultValue;
//				TableCell cell = authoringTable.Rows[rowIndex].Cells[1];
//
//				if (prop.AllowedValues.Count > 0)
//				{
//					// There are specific allowed values - so fill in the drop down list
//					DropDownList list = cell.Controls[0] as DropDownList;
//					if (list == null)
//					{
//						throw new Exception ("Invalid control for custom property");
//					}
//					bool foundItem = false;
//					int itemIndex = 0;
//					foreach (ListItem item in list.Items)
//					{
//						if (item.Value == propDefault)
//						{
//							foundItem = true;
//							list.SelectedIndex = itemIndex;
//						}
//						itemIndex++;
//					}
//					if (!foundItem)
//					{
//						throw new Exception ("Internal exception processing default for " + prop.Name);
//					}
//				}
//				else
//				{
//					// There are no specific allowed values - we expect a text box
//					TextBox tb = cell.Controls[0] as TextBox;
//					if (tb == null)
//					{
//						throw new Exception ("Invalid control for custom property");
//					}
//					tb.Text = propDefault;
//				}
//				rowIndex++;
//			}
		}

		#endregion

		#region Storage Logic - Keeps values in placeholder control for sync to props

		private XmlDocument xmlStore;

		private void InitXml(string xmlString)
		{
			xmlStore = new XmlDocument ();
			if (xmlString != "")
			{
				xmlStore.LoadXml (xmlString);
			}
		}

		private void AddToXml (string propName, string propValue)
		{
			string elementName = propName.Replace (" ", "");

			XmlElement rootElement = xmlStore.FirstChild as XmlElement;
			if (rootElement == null)
			{
				rootElement = xmlStore.CreateElement ("customProperties");
				xmlStore.AppendChild (rootElement);
			}

			XmlNodeList nodes = xmlStore.GetElementsByTagName (elementName);
			XmlElement propElement;
			if (nodes.Count == 0)
			{
				propElement = xmlStore.CreateElement(elementName);
				rootElement.AppendChild (propElement);
			}
			else
			{
				propElement = nodes[0] as XmlElement;
			}
			propElement.InnerText = System.Web.HttpUtility.HtmlEncode (propValue);
		}

		private string GetFromXml (string propName)
		{
			string elementName = propName.Replace (" ", "");

			XmlNodeList nodes = xmlStore.GetElementsByTagName (elementName);
			if (nodes.Count <= 0)
			{
				// It wasn't in the XML, probably a new property for this posting
				// so return the actual property
				return (CmsHttpContext.Current.Posting.CustomProperties[propName].Value);
			}
			XmlElement propElement = nodes[0] as XmlElement;
			if (propElement == null)
			{
				// It wasn't in the XML, probably a new property for this posting
				// so return the actual property
				return (CmsHttpContext.Current.Posting.CustomProperties[propName].Value);
			}
			return (System.Web.HttpUtility.HtmlDecode (propElement.InnerText));
		}

		private string GetXmlString()
		{
			return (xmlStore.OuterXml);
		}

		#endregion

	}
}
